﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.IO;
using System.Windows.Forms;

namespace SWAT_USB_App
{
    class Debug
    {
        private static string debugLocation = Initialization.pathToSWATDrive + "Debug.txt";
        public static void appendText(string text)
        {
            // Appends passed string into Debug.txt
            try
            {
                using (StreamWriter sw = File.AppendText(debugLocation))
                {
                    sw.Write("[" + DateTime.Now.ToLongDateString() + " ; " + DateTime.Now.ToLongTimeString() + "] -- ");
                    sw.Write(text + "\r\n");
                    sw.Flush();
                }
            }
            catch (Exception e)
            {
                MessageBox.Show(e.ToString());
            }
        }
        public static void createNewDebugTxt()
        {
            // Deletes old Debug.txt and creates a new one
            if (File.Exists(debugLocation))
            {
                File.Delete(debugLocation);
                File.Create(debugLocation);
            }
        }
        public static void startNewSession()
        {
            try
            {
                using (StreamWriter sw = File.AppendText(debugLocation))
                {
                    sw.Write("-- New Debug Session --\r\n");
                    sw.Flush();
                }
            }
            catch (Exception e)
            {
                MessageBox.Show(e.ToString());
            }
        }

    }
}
